IF NOT OBJECT_ID('TRG_EST_ALCADA_CP_PED_LIB_AGENDA') IS NULL
	BEGIN 
		DROP TRIGGER TRG_EST_ALCADA_CP_PED_LIB_AGENDA
	END
	
GO	

IF NOT OBJECT_ID('TRG_EST_ALCADA_CP_PED_LIB_ALCADA') IS NULL
	BEGIN 
		DROP TRIGGER TRG_EST_ALCADA_CP_PED_LIB_ALCADA
	END
	
GO	

CREATE TRIGGER TRG_EST_ALCADA_CP_PED_LIB_ALCADA ON EST_ALCADA_CP_PED_LIB FOR INSERT
AS 
	BEGIN
		DECLARE @CD_CTR INT 
		DECLARE @TP_ALCADA INT 
		DECLARE @TP_EVENTO_ALCADA INT 
		
		SELECT 
			@CD_CTR = EST_ALCADA_CP_PED.CD_CTR,
			@TP_ALCADA = EST_ALCADA_CP_PED.TP_ALCADA,
			@TP_EVENTO_ALCADA = EST_ALCADA_CP_PED.TP_EVENTO_ALCADA
		FROM INSERTED I	
			INNER JOIN EST_ALCADA_CP_PED ON
				I.CD_CTR = EST_ALCADA_CP_PED.CD_CTR 			
		
		IF @TP_ALCADA = 0 
			BEGIN
				IF EXISTS (SELECT T.CD_CTR 
						   FROM  EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA T
						   WHERE T.CD_CTR = @CD_CTR)
					BEGIN
						EXECUTE P_EST_PROD_FABRIC_AGENDA_ALCADA @CD_CTR
					END
				ELSE
					BEGIN
						EXECUTE P_EST_PROD_FABRIC_AGENDA_GRUPO_ALCADA @CD_CTR
					END
			END
		ELSE			
			BEGIN
				IF @TP_EVENTO_ALCADA = 0 
					BEGIN 
						EXECUTE P_EST_PROD_CPL_FACE_AGENDA_ALCADA @CD_CTR
					END
				ELSE	
					BEGIN 
						EXECUTE P_EST_PROD_CPL_MEDIAP_AGENDA_ALCADA @CD_CTR
					END
			END 
			
	END